<?php

require_once __DIR__ . '/../init_cloud.php';

$response = [
    'data'   => [],
    'status' => 'failed'
];

http_response_code(422);

$inputRules = [
    "first_name" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "last_name" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "email" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "phone" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "position" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "note" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "status" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
];

$failed = false;

$error = [];

function validateIntPos($id)
{
    return !(empty($id) || !is_numeric($id) || $id < 1);
}

if (__RB_validateInput($inputRules, 'add_meeting_customer', $error)) {
    $objCreate = [];

    foreach ($inputRules as $key => $val) {
        $objCreate[$key] = $_POST[$key];
    }

    $data = [
        'id_customer' => $_SESSION['id'],
        'data' => $objCreate
    ];

    __RB_api_cloud('addMeetingEmployee', $data, $json);

    http_response_code(200);

    $response = ["status" => 'success'];

    echo json_encode($response);

    exit;
} else {
    $response = [
        'status' => 'failed',
        'errors' => $error
    ];

    echo json_encode($response);

    exit;
}
