<?php

function  __RB_api_cloud($action, $data, &$json) {
    $data['action'] = $action;

    if (in_array($action, [__RB_API_ACTION_CLOUD_GET_GENRES, __RB_API_ACTION_CLOUD_GET_CATEGORIES, __RB_API_ACTION_CLOUD_GET_EXT_FOOD_CATEGORIES, __RB_API_ACTION_CLOUD_GET_FILES_LATEST, __RB_API_ACTION_CLOUD_GET_FILES_LATEST_VIDEO, __RB_API_ACTION_CLOUD_GET_FILES_LATEST_PDF, __RB_API_ACTION_CLOUD_GET_FILES_LATEST_VIDEO_BUNDLE, __RB_API_ACTION_CLOUD_GET_FILES_LATEST_PDF_BUNDLE, __RB_API_ACTION_CLOUD_GET_FILES, __RB_API_ACTION_CLOUD_GET_EXT_FOOD_FILES])) {
        $list = __RB_getCachedApi($action . '_' . md5(serialize($data))) ?: null;

        if (!empty($list) && $list['timestamp'] >= time() - 1000 * 60 * 60) {
            $json = $list['json'];

            return $list['result'];
        }

        $newList = __RB_api(__RB_API_SERVICE_CLOUD, $data, $json);

        __RB_storeCachedApi($action . '_' . md5(serialize($data)), ['timestamp' => time(), 'data' => $data, 'result' => $newList, 'json' => $json]);
    }
    else {
        $newList = __RB_api(__RB_API_SERVICE_CLOUD, $data, $json);
    }

    return $newList;
}

function __RB_api_checkout($action, $data, &$json, $url) {
    $data['action'] = $action;

    if (false && in_array($action, [__RB_API_ACTION_CHECKOUT_CONFIG])) {
        $list = __RB_getCachedApi($action . '_' . md5(serialize($data))) ?: null;

        if (!empty($list) && $list['timestamp'] >= time() - 10 * 60 * 60 && $list['result']) {
            $json = $list['json'];

            return $list['result'];
        }

        $newList = __RB_api($url, $data, $json);

        __RB_storeCachedApi($action . '_' . md5(serialize($data)), ['timestamp' => time(), 'data' => $data, 'result' => $newList, 'json' => $json]);
    }
    else {
        $newList = __RB_api($url, $data, $json);
    }

    return $newList;
}

function __RB_put_ini_file($file, $array, $i = 0) {
    $str = '';

    foreach ($array as $k => $v) {
        if (is_array($v)) {
            $str .= str_repeat(' ', $i * 2) . "[{$k}]" . PHP_EOL;
            $str .= __RB_put_ini_file('', $v, $i + 1);
        }
        else {
            $str .= str_repeat(' ', $i * 2) . "{$k} = \"{$v}\"" . PHP_EOL;
        }
    }

    if ($file) {
        return file_put_contents($file, $str);
    }
    else {
        return $str;
    }
}

function __RB_validateInput($inputRules, $action, &$ajax = null) {
    global $__RB_error, $__RB_LNG;

    $success = true;

    foreach ($inputRules as $id => $rule) {
        $message  = isset($__RB_LNG['validation'][$id]) ? $__RB_LNG['validation'][$id] : [];
        $name     = isset($message['name']) ? $message['name'] : $__RB_LNG['error']['name'];
        $required = !isset($rule['required']) || $rule['required'];

        if (!isset($_POST[$id])) {
            if ($required) {
                if ($ajax !== null) {
                    $ajax[] = ['type' => 'field', 'name' => $id, 'code' => 1, 'message' => isset($message['missing']) ? $message['missing'] : $__RB_LNG['error']['missing'] . $name];
                }
                else {
                    __RB_errorHandler($action, $id, isset($message['missing']) ? $message['missing'] : $__RB_LNG['error']['missing'] . $name);
                }

                $success = false;
            }

            continue;
        }

        if (isset($_POST[$id])) {
            $input = isset($rule['replace']) ? str_replace($rule['replace'][0], $rule['replace'][1], $_POST[$id]) : $_POST[$id];
        }
        else {
            $input = '';
        }

        if (empty($input) && $required) {
            if ($ajax !== null) {
                $ajax[] = ['type' => 'field', 'name' => $id, 'code' => 2, 'message' => isset($message['empty']) ? $message['empty'] : $name . ' ' . $__RB_LNG['error']['empty']];
            }
            else {
                __RB_errorHandler($action, $id, isset($message['empty']) ? $message['empty'] : $name . ' ' . $__RB_LNG['error']['empty']);
            }

            $success = false;

            continue;
        }

        $validate = $rule['validate'];

        if ($required && (
            isset($validate['regex']) && !preg_match($validate['regex'], $input) ||
            isset($validate['filter']) && !filter_var($input, $validate['filter']) ||
            isset($validate['custom']) && !$validate['custom']($input)
        )) {
            if ($ajax !== null) {
                $ajax[] = ['type' => 'field', 'name' => $id, 'code' => 3, 'message' => isset($message['validation']) ? $message['validation'] : $name . ' ' . $__RB_LNG['error']['validation']];
            }
            else {
                __RB_errorHandler($action, $id, isset($message['validation']) ? $message['validation'] : $name . ' ' . $__RB_LNG['error']['validation']);
            }

            $success = false;
        }
    }

    return $success;
}

function __RB_errorHandler($action, $id, $msg) {
    global $__RB_error;

    if (empty($__RB_error[$action]) || !is_array($__RB_error[$action])) {
        $__RB_error[$action] = [];
    }

    if (!isset($__RB_error[$action][$id])) {
        $__RB_error[$action][$id] = [];
    }

    $__RB_error[$action][$id][] = $msg;
}

function __RB_error_alert($errors) {
    global $__RB_LNG;

    $error = $__RB_LNG['error']['occurred'];

    if (is_array($errors)) {
        $error .= '\n';

        foreach ($errors as $val) {
            $error .= '\n';

            if (is_array($val)) {
                foreach ($val as $key => $msg) {
                    $error .= ' - ' . $msg;
                    $error .= '\n';
                }
            }
            else {
                $error .= ' - ' . $val;
            }
        }
    }

    echo "<script>alert('" . str_replace("'", "\'", $error) . "');</script>";
}

function __RB_success_alert($action, $type = 'form') {
    global $__RB_LNG;

    echo '<script>';

    $success = 'Success';

    if (!empty($type) && !empty($__RB_LNG['success'][$type]) && !empty($__RB_LNG['success'][$type][$action])) {
        $success = $__RB_LNG['success'][$type][$action];
    }
    elseif (!empty($__RB_LNG['success'][$action])) {
        $success = $__RB_LNG['success'][$action];
    }

    // echo "alert('" . $success . "');";
    echo "alert('" . str_replace("'", "\'", $success) . "');";

    echo '</script>';
}

function __RB_convertInterval($interval, $unit) {
    $interval = (int)$interval;

    switch ($unit) {
        case 'month': $interval *= 30; break;
        case 'week': $interval *= 7; break;
    }

    return $interval;
}

function __RB_signedIn() {
    return isset($_SESSION) && (!empty($_SESSION['signed_in']) && $_SESSION['signed_in'] || !empty($_SESSION['id']));
}

function __RB_noLotteryWinners() {
    return empty(__RB_getLotteryWinners());
}

function __RB_noProductWinners() {
    return empty(__RB_getProductsWinners());
}

function __RB_getLotteryPrevious($limit = 0) {
    global $__RB_config;

    if ($limit) {
        return array_slice($__RB_config['lotteries_prev'], 0, $limit, true);
    }

    return $__RB_config['lotteries_prev'];
}

function __RB_getLotteryWinners() {
    global $__RB_config;

    return $__RB_config['lotteries_winner'];
}

function __RB_getLotteryCustomerWon() {
    return $_SESSION['lotteries']; //array_filter($_SESSION['lotteries'], function($obj) { return $obj['status'] == 1; });
}

function __RB_getLotteryCustomerActive() {
    return array_filter($_SESSION['lotteries'], function ($obj) { return strtotime($obj['date']) >= strtotime(date('Y-m-d', time())); });
}

function __RB_lotteryNewGroup($row, &$last) {
    if ($row['amount'] != $last) {
        $last = $row['amount'];

        return true;
    }

    return false;
}

function __RB_lotteryGroupAmount($amount) {
    switch ($amount) {
        case 1000000: return '1 Million';
        case 100000: return '100.000';

        default: return '50.000';
    }
}

function __RB_lotteryPayout() {
    return number_format(array_sum(array_column(array_filter($_SESSION['lotteries'], function ($obj) { return $obj['status'] == 1 && $obj['paidout'] == 0; }), 'amount')), 2, ',', '.');
}

function __RB_getProductsPool($limit = 0) {
    global $__RB_config;

    if ($limit) {
        return array_slice($__RB_config['prizes'], 0, $limit, true);
    }

    return $__RB_config['prizes'];
}

function __RB_getProductsWinners($limit = 0) {
    global $__RB_config;

    if ($limit) {
        return array_slice($__RB_config['prizes_winner'], 0, $limit, true);
    }

    return $__RB_config['prizes_winner'];
}

function __RB_getExtFoodCategories($random = 0, $selected = 0) {
    $data = [];

    if ($selected > 1) {
        $data = [
            'id_category' => $selected
        ];
    }

    if ($selected == 1 && !empty($_GET['idCategory'])) {
        $data = [
            'id_category' => $_GET['idCategory']
        ];
    }

    if (!empty($_GET['file_search'])) {
        if (empty($data)) {
            $data = [];
        }

        $data['s_name'] = htmlspecialchars_decode($_GET['file_search']);
    }

    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_EXT_FOOD_CATEGORIES, ['data' => $data], $json)) {
        if ($selected) {
            if (!isset($_GET['idCategory'])) {
                $_GET['idCategory'] = '';
            }

            foreach ($json['data'] as $category) {
                if ($category['id'] == $_GET['idCategory'] || $category['id'] == $selected) {
                    return [$category];
                }
            }

            return [];
        }

        if ($random) {
            shuffle($json['data']);

            return array_slice($json['data'], 0, $random);
        }

        return $json['data'];
    }

    return [];
}

function __RB_getCategories($random = 0, $selected = 0) {
    $data = [];

    if ($selected > 1) {
        $data = [
            'id_category' => $selected
        ];
    }

    if ($selected == 1 && !empty($_GET['idCategory'])) {
        $data = [
            'id_category' => $_GET['idCategory']
        ];
    }

    if (!empty($_GET['file_search'])) {
        if (empty($data)) {
            $data = [];
        }

        $data['s_name'] = htmlspecialchars_decode($_GET['file_search']);
    }

    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_CATEGORIES, ['data' => $data], $json)) {
        if ($selected) {
            if (!isset($_GET['idCategory'])) {
                $_GET['idCategory'] = '';
            }

            foreach ($json['data'] as $category) {
                if ($category['id'] == $_GET['idCategory'] || $category['id'] == $selected) {
                    return [$category];
                }
            }

            return [];
        }

        if ($random) {
            shuffle($json['data']);

            return array_slice($json['data'], 0, $random);
        }

        return $json['data'];
    }

    return [];
}

function __RB_getGenre($random = 0, $selected = 0) {
    $data = [];

    if ($selected > 1) {
        $data = [
            'id_genre' => $selected
        ];
    }

    if (!empty($_GET['idGenre']) && $selected == 0) {
        $data = [
            'id_genre' => $_GET['idGenre']
        ];
    }

    if (!empty($_GET['file_search']) && $selected == 0) {
        if (empty($data)) {
            $data = [];
        }

        $data['s_name'] = htmlspecialchars_decode($_GET['file_search']);
    }

    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_GENRES, ['data' => $data], $json)) {
        if ($selected > 1) {
            if (!isset($_GET['idCategory'])) {
                $_GET['idCategory'] = '';
            }

            foreach ($json['data'] as $category) {
                if ($category['id'] == $_GET['idGenre'] || $category['id'] == $selected) {
                    return [$category];
                }
            }

            return [];
        }

        if ($random) {
            shuffle($json['data']);

            return array_slice($json['data'], 0, $random);
        }

        return $json['data'];
    }

    return [];
}

function __RB_getFilesLatest($limit = 10) {
    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_FILES_LATEST, ['limit' => $limit], $json)) {
        return $json['data'];
    }

    return [];
}

function __RB_getFilesLatestExtFood($limit = 10) {
    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_EXT_FOOD_CATEGORIES, ['limit' => $limit], $json)) {
        $files = [];

        $counter = 1;

        foreach ($json['data'] as $cat) {
            foreach ($cat['files'] as $f) {
                $files[] = $f;

                $counter++;

                if ($counter > $limit) {
                    break;
                }
            }

            if ($counter > $limit) {
                break;
            }
        }

        return $files;
    }

    return [];
}

function __RB_getFiles() {
    $data = ['data' => []];

    if (!empty($_GET['file_search'])) {
        $data['data']['s_name'] = htmlspecialchars_decode($_GET['file_search']);
    }

    if (!empty($_GET['idCategory'])) {
        $data['data']['id_category'] = $_GET['idCategory'];
    }

    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_FILES, $data, $json)) {
        return $json['data'];
    }

    return [];
}

function __RB_getFilesLatestVideo() {
    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_FILES_LATEST_VIDEO, [], $json)) {
        return $json['data'];
    }

    return [];
}

function __RB_getFilesLatestPdf() {
    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_FILES_LATEST_PDF, [], $json)) {
        return $json['data'];
    }

    return [];
}

function __RB_getFilesLatestVideoBundle() {
    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_FILES_LATEST_VIDEO_BUNDLE, [], $json)) {
        return $json['data'];
    }

    return [];
}

function __RB_getFilesLatestPdfBundle() {
    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_FILES_LATEST_PDF_BUNDLE, [], $json)) {
        return $json['data'];
    }

    return [];
}

function __RB_getFilesSearched() {
    $list = [];

    if (!empty($_GET['file_search']) && __RB_api_cloud(__RB_API_ACTION_CLOUD_GET_FILES, [
        'data' => ['s_name' => htmlspecialchars_decode($_GET['file_search']), 'id_category' => !empty($_GET['idCategory']) ? $_GET['idCategory'] : '']
    ], $json)) {
        $list = $json['data'];
    }

    return $list;
}

function __RB_getFilesFavorites($ext = '') {
    $list = [];

    if (!empty($_SESSION['favorites']) && __RB_api_cloud(__RB_API_ACTION_CLOUD_GET_FILES, [], $json)) {
        foreach ($json['data'] as $file) {
            if (!empty($_SESSION['favorites'][$file['id']]) && $_SESSION['favorites'][$file['id']] == true && (empty($ext) || $ext == $file['ext'])) {
                $list[] = $file;
            }
        }
    }

    return $list;
}

function __RB_getFilesSelected() {
    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_FILES, ['data' => ['id_file' => $_GET['idFile']]], $json)) {
        if (!empty($_GET['idFile'])) {
            foreach ($json['data'] as $file) {
                if ($file['id'] == $_GET['idFile']) {
                    $_GET['idCategory'] = $file['id_global_category'];

                    return [$file];
                }
            }
        }
    }

    return [];
}

function __RB_getFilesSelectedExtFood() {
    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_GET_EXT_FOOD_FILES, ['data' => ['id_file' => $_GET['idFile']]], $json)) {
        //if (!empty($_GET['idFile'])) {
        foreach ($json['data'] as $file) {
            //if ($file['id'] == $_GET['idFile']) {
            //$_GET['idCategory'] = $file['id_global_category'];

            return [$file];
            //}
        }
        //}
    }

    return [];
}

function __RB_fileVoted($vote, $row) {
    return !empty($_SESSION['votes']) && !empty($_SESSION['votes'][$row['id']]) && $_SESSION['votes'][$row['id']] == $vote ? 'checked' : '';
}

function __RB_fileVotedCheck($vote, $row) {
    return !empty($_SESSION['votes']) && !empty($_SESSION['votes'][$row['id']]) && $_SESSION['votes'][$row['id']] == $vote;
}

function __RB_prizeOrder($number, $sup = 0) {
    switch ($number) {
        case 1: return $number . ($sup == 2 ? '' : (($sup ? '<sup>' : '') . 'st' . ($sup ? '</sup>' : ''))) ;
        case 2: return $number . ($sup == 2 ? '' : (($sup ? '<sup>' : '') . 'nd' . ($sup ? '</sup>' : ''))) ;
        case 3: return $number . ($sup == 2 ? '' : (($sup ? '<sup>' : '') . 'rd' . ($sup ? '</sup>' : ''))) ;
        case 21: return $number . ($sup == 2 ? '' : (($sup ? '<sup>' : '') . 'st' . ($sup ? '</sup>' : ''))) ;
        case 22: return $number . ($sup == 2 ? '' : (($sup ? '<sup>' : '') . 'nd' . ($sup ? '</sup>' : ''))) ;
        case 23: return $number . ($sup == 2 ? '' : (($sup ? '<sup>' : '') . 'rd' . ($sup ? '</sup>' : ''))) ;
        case 31: return $number . ($sup == 2 ? '' : (($sup ? '<sup>' : '') . 'st' . ($sup ? '</sup>' : ''))) ;
        case 32: return $number . ($sup == 2 ? '' : (($sup ? '<sup>' : '') . 'nd' . ($sup ? '</sup>' : ''))) ;
        case 33: return $number . ($sup == 2 ? '' : (($sup ? '<sup>' : '') . 'rd' . ($sup ? '</sup>' : ''))) ;
        default: return $number . ($sup == 2 ? '' : (($sup ? '<sup>' : '') . 'th' . ($sup ? '</sup>' : ''))) ;
    }
}

function __RB_redirectToAccount() {
    if (!empty($_SESSION) && !empty($_SESSION['id']) && (!empty($_SESSION['signed_in']) && $_SESSION['signed_in'] == true)) {
        header('location: /account/my-account.html');

        exit;
    }
}

function __RB_signedInOnly() {
    if (empty($_SESSION) || empty($_SESSION['id']) && (empty($_SESSION['signed_in']) || $_SESSION['signed_in'] !== true)) {
        echo "
        <script>
            alert('Please sign in to access this page');

            window.location.href = '/';
        </script>";

        exit;
    }
}

function __RB_getCustomerTransactions() {
    return $_SESSION['transactions'];
}

function __RB_getActiveCategoryMatchClass($row) {
    if (empty($row['idCategory'])) {
        return '';
    }

    $rowId = $row['id'];

    if (!empty($_GET['idCategory']) && $_GET['idCategory'] == $rowId || !empty($_POST['idCategory']) && $_POST['idCategory'] == $rowId) {
        return 'active';
    }

    return '';
}

function __RB_getActiveGenreMatchClass($row) {
    if (empty($row['id'])) {
        return '';
    }

    $rowId = $row['id'];

    if (!empty($_GET['idGenre']) && $_GET['idGenre'] == $rowId || !empty($_POST['idGenre']) && $_POST['idGenre'] == $rowId) {
        return 'active';
    }

    return '';
}

function __RB_getStatusClass($status) {
    switch ($status) {
        case 1: return 'paid';
        case 3: return 'paid';
        case 2: return 'failed';
    }

    return '';
}

function __RB_getStatusText($status) {
    switch ($status) {
        case 1: return 'Paid';
        case 3: return 'Refund';
        case 2: return 'Failed';
    }

    return 'Draft';
}

function __RB_getShippingStatusClass($status) {
    switch ($status) {
        case 1: return 'success';
        case 3: return 'failed';
        case 2: return 'failed';
    }

    return 'pending';
}

function __RB_getShippingStatusText($status) {
    switch ($status) {
        case 1: return 'Delivered';
        case 3: return 'Cancelled';
        case 2: return 'Failed';
    }

    return 'Pending';
}

function __RB_getMeetingCustomerStatusClass($status) {
    switch ($status) {
        case 1: return 'Active';
        case 2: return 'Not Active';
    }

    return 'pending';
}

function __RB_getMeetingCustomerStatusText($status) {
    switch ($status) {
        case 1: return 'Active';
        case 2: return 'Not Active';
    }

    return 'Pending';
}   

function __RB_fileFavorited($row) {
    return !empty($_SESSION['favorites']) && !empty($_SESSION['favorites'][$row['id']]) && $_SESSION['favorites'][$row['id']] == true;
}

function __RB_getShoppingList($action = 0) {
    $list = __RB_getSession('shoppingList') ?: [];

    if ($action == 1 && !empty($_GET['shoppingListEdit']) && is_numeric($_GET['shoppingListEdit']) && $_GET['shoppingListEdit'] > 0) {
        foreach ($list as $obj) {
            if ($obj['id'] == $_GET['shoppingListEdit']) {
                if (empty($obj['items'])) {
                    $obj['items'] = [[
                        'text' => '',
                        'done' => 0
                    ]];
                }
                return [$obj];
            }
        }

        return [];
    }
    elseif ($action == 2 && !empty($_GET['shoppingList']) && is_numeric($_GET['shoppingList']) && $_GET['shoppingList'] > 0) {
        foreach ($list as $obj) {
            if ($obj['id'] == $_GET['shoppingList']) {
                return [$obj];
            }
        }

        return [];
    }
    else {
        return $list;
    }
}

//TODO
function __RB_getShippingList($id = 0) {
    $data = [
        'id_customer' => $_SESSION['id'],
        'type' => 2
    ];

    if ($id && is_numeric($id) && $id > 0) {
        $data['id'] = $id;
    }

    __RB_api_cloud(__RB_API_ACTION_CLOUD_GET_SHIPPING, ['data' => $data], $json);

    return $json['data'];
}

function __RB_getMeetingList($id = 0) {
    $data = [
        'id_customer' => $_SESSION['id']
    ];

    if ($id && is_numeric($id) && $id > 0) {
        $data['id'] = $id;
    }

    __RB_api_cloud(__RB_API_ACTION_CLOUD_GET_MEETING, ['data' => $data], $json);

    return $json['data'];
}

function __RB_getMeetingCustomerList($id = 0) {
    $data = [
        'id_customer' => $_SESSION['id']
    ];

    if ($id && is_numeric($id) && $id > 0) {
        $data['id'] = $id;
    }

    __RB_api_cloud(__RB_API_ACTION_CLOUD_GET_MEETING_CUSTOMERS, ['data' => $data], $json);

    return $json['data'];
}

function __RB_getMeetingEmployeeList($id = 0) {
    $data = [
        'id_customer' => $_SESSION['id']
    ];

    if ($id && is_numeric($id) && $id > 0) {
        $data['id'] = $id;
    }

    __RB_api_cloud(__RB_API_ACTION_CLOUD_GET_MEETING_EMPLOYEE, ['data' => $data], $json);

    return $json['data'];
}

function __RB_getCachedApi($key) {
    $session = json_decode(@file_get_contents(__DIR__ . '/user/storage/apiCache.json') ?: '{}', true);

    return @$session[$key] ?: null;
}

function __RB_storeCachedApi($key, $data) {
    $session = json_decode(@file_get_contents(__DIR__ . '/user/storage/apiCache.json') ?: '{}', true);

    $session[$key] = $data;

    file_put_contents(__DIR__ . '/user/storage/apiCache.json', json_encode($session));
}

function __RB_getSession($key) {
    $session = json_decode(@file_get_contents(__DIR__ . '/user/storage/' . $_SESSION['id'] . '.json') ?: '{}', true);

    return @$session[$key] ?: '';
}

function __RB_storeSession($key, $data) {
    $session = json_decode(@file_get_contents(__DIR__ . '/user/storage/' . $_SESSION['id'] . '.json') ?: '{}', true);

    $session[$key] = $data;

    file_put_contents(__DIR__ . '/user/storage/' . $_SESSION['id'] . '.json', json_encode($session));
}

function __RB_setLng($lng) {
    $lngName = [
        'de' => 'German',
        'en' => 'English',
        'es' => 'Spanish',
        'fr' => 'French',
        'it' => 'Italian',
    ];

    if (!empty($lngName[$lng])) {
        $_SESSION['lng']     = $lng;
        $_SESSION['lngName'] = $lngName[$lng];
    }
}

function __RB_checkCountry($code) {
    global $__RB_config;

    if ($code == 'uk') {
        return ucwords(strtolower($__RB_config['company']['country'])) == 'United Kingdom' || ucwords(strtolower($__RB_config['company']['country'])) == 'England';
    }

    if ($code == 'cy') {
        return ucwords(strtolower($__RB_config['company']['country'])) == 'Cyprus';
    }
    
    if ($code == 'pl') {
        return ucwords(strtolower($__RB_config['company']['country'])) == 'Poland';
    }

    return false;
}

function __RB_checkPending($row) {
    return empty($row['status']);
}
