<?php

$inputRules = [
    "from_firstname" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_lastname" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_email" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_phone" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_address" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_zipcode" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_city" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_state" => ["required" => false, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_country" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],

    "to_firstname" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_lastname" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_email" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_phone" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_address" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_zipcode" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_city" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_state" => ["required" => false, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_country" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],

    "subject" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "date" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "note" => ["required" => false, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
];

$failed = false;

if (__RB_validateInput($inputRules, 'shipping_upload')) {
    $failed = false;

    $oldPost = $_POST;

    $objCreate = [
        'files' => []
    ];

    foreach ($inputRules as $key => $val) {
        $objCreate[$key] = $_POST[$key];
    }

    foreach ($_FILES["upload"]["error"] as $key => $error) {
        if ($error != UPLOAD_ERR_OK) {
            $failed = true;
        }

        $finfo = new finfo(FILEINFO_MIME_TYPE);

        if ('application/pdf' != $finfo->file($_FILES['upload']['tmp_name'][$key])) {
            __RB_errorHandler('shipping_upload', 'upload', 'Upload File : '. $__RB_LNG['error']['validation']);

            $failed = 2;
        }
    }

    $date = explode('-', $_POST['date']);
    $date2 = explode('/', $_POST['date']);

    if (empty($data[1]) && !empty($date2[1])) {
        $date = $date2;
    }

    $year = $date[2];
    $month = $date[0];
    $day = $date[1];

    if (!checkdate($month, $day, $year)) {
        __RB_errorHandler('shipping_upload', 'date', 'Date : ' . $__RB_LNG['error']['validation']);

        $failed = 2;
    }

    if (!$failed) {
        foreach ($_FILES["upload"]["tmp_name"] as $key => $error) {
            move_uploaded_file($_FILES["upload"]["tmp_name"][$key], __DIR__ . '/../user/storage/upload/' . $_SESSION['id'] . '_' . $key .'_'. time() . '.pdf');
            $objCreate['files'][$_FILES["upload"]["name"][$key]]  = $_SESSION['id'] . '_' . $key .'_'. time() . '.pdf';

        }

        $json = "";
        
        $data = [
            'id_customer' => $_SESSION['id'],
            'data' => $objCreate
        ];

        __RB_api_cloud(__RB_API_ACTION_CLOUD_ADD_SHIPPING, $data, $json);

        $__RB_success['shipping_upload'] = true;

        $_POST = [];

    } else {
        if ($failed !== 2) {
            __RB_errorHandler('shipping_upload', 'upload', $__RB_LNG['error']['missing'] . ' Upload file');
        }
    }
}
