<?php

$languageValidation = [
    "firstName" => [
        "name" => "First Name",
        "validation" => "First name isn't valid"
    ],
    "lastName" => [
        "name" => "Last Name",
        "validation" => "Last name isn't valid"
    ],
    "address" => [
        "name" => "Address",
        "validation" => "The adress isn't valid"
    ],
    "postalCode" => [
        "name" => "Postal code",
        "validation" => "The postal code isn't valid"
    ],
    "city" => [
        "name" => "City",
        "validation" => "The city isn't valid"
    ],
    "emailAddress" => [
        "name" => "E-mail address",
        "validation" => "The e-mail isn't valid"
    ],
    "oldEmailAddress" => [
        "name" => "Current e-mail address",
        "validation" => "The e-mail isn't valid"
    ],
    "newEmailAddress" => [
        "name" => "New e-mail address",
        "validation" => "The new e-mail address isn't valid"
    ],
    "newEmailAddressRepeat" => [
        "name" => "Repeat e-mail address",
        "validation" => "The repeated e-mail address isn't valid"
    ],
    "phoneNumber" => [
        "name" => "Phone",
        "validation" => "The phone number isn't valid"
    ],
    "tos" => [
        "name" => "Terms & Conditions",
        "validation" => "You have to accept our terms & conditions",
        "missing" => "You have to accept our terms & conditions"
    ],
    "cardHolder" => [
        "name" => "Card holder",
        "validation" => "The card holder's name isn't valid"
    ],
    "cardNumber" => [
        "name" => "Card number",
        "validation" => "The card number isn't valid"
    ],
    "expiryDate" => [
        "name" => "Expiry date",
        "validation" => "The expiry date isn't valid"
    ],
    "cvcNumber" => [
        "name" => "Security code",
        "validation" => "The security code isn't valid"
    ],
    "password" => [
        "name" => "Password"
    ],
    "oldPassword" => [
        "name" => "Current password"
    ],
    "newPassword" => [
        "name" => "New password"
    ],
    "newPasswordRepeat" => [
        "name" => "Repeat password"
    ],
];

$languageStd = [
    "missing" => "Missing input field: ",
    "validation" => "The field isn't valid",
    "empty" => " cannot be empty",
    "name" => "UNKNOWN!",
    "notComplete" => "Please fill in the fields correctly"
];

$languageForm = [
    "login" => [
        "label" => [
            "emailAddress" => "E-mail address",
            "password" => "Password",
            "rememberMe" => "Remember me",
            "lostPassword" => "Lost your password?"
        ],
        "submit" => "Sign In"
    ],
    "changePassword" => [
        "label" => [
            "oldPassword" => "Current password",
            "newPassword" => "New password",
            "newPasswordRepeat" => "Repeat password"
        ],
        "submit" => "Change password"
    ],
    "forgottenPassword" => [
        "label" => [
            "emailAddress" => "E-mail address"
        ],
        "submit" => "Reset password",
        "success" => "A verification mail has been sent to you if this e-mail address exists in our database. The mail will also list the details on how to reset your password."
    ],
    "changeAddress" => [
        "label" => [
            "firstName" => "First name",
            "lastName" => "Last name",
            "address" => "Address",
            "postalCode" => "Postal code",
            "city" => "City",
            "phoneNumber" => "Phone"
        ],
        "submit" => "Update address"
    ],
    "changeCreditCard" => [
        "label" => [
            "cardHolder" => "Card holder",
            "cardNumber" => "Card number",
            "expiryDate" => "Expiry date",
            "cvcNumber" => "Security code"
        ],
        "submit" => "Change credit card"
    ],
    "changeEmailAddress" => [
        "label" => [
            "oldEmailAddress" => "Current e-mail address",
            "newEmailAddress" => "New e-mail address",
            "newEmailAddressRepeat" => "Repeat e-mail addresse"
        ],
        "submit" => "Change e-mail adresse"
    ]
];

$languageContent = [
    "logout" => [
        "loggedOut" => "You are now signed out."
    ]
];

$languageError = [
	"login" => [
        "wrongLogin" => "The e-mail or password is incorrect.",
        "notActive" => "You are no longer subscribing to our service and can thus not sign in."
    ],
	"profile" => [
        "transaction" => "Couldn't retrieve your transactions log.",
        "cancel" => "Something went wrong when we tried to unsubscribe you. Try again or please contact us.",
    ],
    "changePassword" => [
        "didntMatch" => "The new password and repeat password doesn't match up.",
        "oldNewSame" => "The current password and new password may not be the same.",
        "oldWrong" => "The entered current password is incorrect."
    ],
    "changeEmailAddress" => [
        "didntMatch" => "The new e-mail and repeated e-mail address doesn't match up.",
        "oldNewSame" => "The current and new e-mail address may not be the same.",
        "oldWrong" => "The entered current e-mail address is incorrect.",
        "mailInUse" => "This e-mail address is already in use by someone else. Please try another."
    ],
    "changeAddress" => [
        "default" => "An error occurred. Did you input everything correctly?"
    ],
    "changeCreditCard" => [
        "invalidCreditCard" => "The credit card details couldn't be approved. Please try again."
    ],
    "forgottenPassword" => [
        "wrongMail" => "A user with this e-mail address doesn't exist."
    ]
];

$languageSuccess = [
    "profile" => [
        "unsubscribed" => "You are now unsubscribed. We will no longer charge you.",
        "logout" => "As you have unsubscribed your membership, we will then have to sign you out. Thank you."
    ],
    "changeAddress" => [
        "changed" => "The address has been updated."
    ],
    "changePassword" => [
        "changed" => "The password has been changed."
    ],
    "changeEmailAddress" => [
        "changed" => "The e-mail adressen has been changed."
    ],
    "changeCreditCard" => [
        "changed" => "Credit card has been replaced with the new one."
    ],
    "forgottenPassword" => [
        "sent" => "An e-mail has been sent to you with more information."
    ]
];

/*  Router System - language Cfg -> Page

    Menu Structure:
    pageName => ["
        "link" => Address to be displayed in the url (regex: [a-b-_0-9]+),
        "title" => Title of the pagem
        "display" => 0 - it is a navigation, but shouldn't be displayed in the menu.
                     1 - it is a navigation for logged out users
                     2 - it is a naviagion for logged in users
                     3 - it is a navigation for both logged in and out users
    "]
*/

$languageCfg = [
    "page" => [
		"userLinks" => [
			"title" => "User panel",
			"display" => 0
		],
        "forgottenPassword" => [
            "link" => "forgotten-password",
            "title" => "Forgot password",
            "ro" => 1,
        ],
        "resetPassword" => [
            "link" => "reset-password",
            "title" => "Reset password",
            "display" => 0,
        ],
        "login" => [
            "link" => "sign-in",
            "title" => "Sign In",
            "display" => 1,
        ],
        "profile" => [
            "link" => "profile",
            "title" =>  "Profile",
            "display" => 2,
        ],
        "changeCreditCard" => [
            "link" => "change-credit-card",
            "title" => "Change credit card",
            "display" => 0,
        ],
        "changeAddress" => [
            "link" => "change-address",
            "title" => "Change address",
            "display" => 2,
        ],
        "changeEmailAddress" => [
            "link" => "change-email-address",
            "title" => "Change e-mail address",
            "display" => 2,
        ],
        "changePassword" => [
            "link" => "change-password",
            "title" =>  "Change password",
            "display" => 2,
        ],
        "logout" => [
            "link" => "sign-out",
            "title" =>  "Sign Out",
            "display" => 2,
        ]
    ]
];

$languagePage = &$languageCfg['page']; //Shortcut to $languageCfg['page']
