var validate = {
    "notEmpty": function (event) {
        setFieldValid(this, this.value && this.value.length > 0, event);
    },
    "name": function (event) {
        setFieldValid(this, regex.nameExtra.test(this.value), event);
    },
    "nameNumberExtra": function (event) {
        setFieldValid(this, regex.nameNumberExtra.test(this.value), event);
    },
    "postal": function (event) {
        setFieldValid(this, regex.postalNumberExtra.test(this.value), event);
    },
    "numberExtra": function (event) {
        setFieldValid(this, regex.numberExtra.test(this.value), event);
    },
    "number": function (event) {
        setFieldValid(this, regex.number.test(this.value), event);
    },
    "numberCvc": function (event) {
        setFieldValid(this, regex.numberCvc.test(this.value), event);
    },
    "mail": function (event) {
        setFieldValid(this, regex.mail.test(this.value), event);
    },
    "checkbox": function (event) {
        setFieldValid(this, $(this).is(":checked"), event);
    },
    "creditCard": function (event) {
        var value = this.value.match(/[\d\.]+/g),
            card = "none",
            key = ("" + event.key).toLowerCase();

        if (key == "delete" || key == "backspace") {
            var tmp = this.value.split(" ");

            if (tmp && tmp[tmp.length - 1] == "") {
                this.value = this.value.substr(0, this.value.length - 1);
            }

            return setFieldValid(this, this.value.length > 18, event);
        }

        if (!value) {
            this.value = "";

            return setFieldValid(this, false, event);
        }

        this.value = value = "" + value.join("").substr(0, 19).replace(/(.{4})/g, '$1 ');

        if (value.length > 0 && value[0] == 4) {
            card = "url(assets/images/visa.svg)";

        } else if (value.length > 1 && value[0] == 5 && (value[1] >= 1 && value[1] <= 5) || value.length > 3 && value.substr(0, 4) >= 2221 && value.substr(0, 4) <= 2720) {
            card = "url(assets/images/mastercard.svg)";
        }

        $("#card_number").css("background-image", card);

        return setFieldValid(this, this.value.length > 18, event);
    },
    "expiryDate": function (event) {
        var key = ("" + event.key).toLowerCase();

        if (key == "delete" || key == "space" || key == "backspace" || key == " ") {
            if (this.value.length > 2 && this.value.length < 5) {
                this.value = this.value[0] + this.value[1];
            }

            return setFieldValid(this, false, event);
        }

        var month_year = this.value.match(/[\d\.]+/g),
            value = "",
            now_year = "" + new Date().getFullYear();

        if (!month_year || month_year < 0) {
            this.value = "";

            return setFieldValid(this, false, event);
        }

        month_year = month_year.join("");

        if (month_year[0] > 1) {
            month_year = 0 + month_year;
        }

        for (var i = 0; i < month_year.length && value.length < 7; i++) {
            if (i === 0 && (parseInt(month_year[0]) < 3) ||
                i === 1 && (parseInt(month_year[0]) === 0 && parseInt(month_year[1]) > 0 || parseInt(month_year[0]) === 1 && parseInt(month_year[1]) < 3) ||
                i === 2 && parseInt(month_year[2]) >= parseInt(now_year[2]) ||
                i === 3 && (parseInt(month_year[2]) === parseInt(now_year[2]) && parseInt(month_year[3]) >= parseInt(now_year[3]) || parseInt(month_year[2]) > parseInt(now_year[2]))) {

                value += month_year[i];

            } else {
                break;
            }

            if (value.length === 2) {
                value += " / ";
            }
        }

        this.value = value;

        month_year = value.split("/");
        now_year = parseInt(now_year);

        if (month_year.length != 2 || !Number(month_year[1])) {
            return setFieldValid(this, false, event);
        }

        var month = parseInt(month_year[0]),
            year = 2000 + parseInt(month_year[1]),
            now_month = new Date().getMonth() + 1;

        if (year < now_year || now_year > year || now_year == year && month < now_month) {
            return setFieldValid(this, false, event);
        }

        return setFieldValid(this, true, event);
    }
};

function setFieldValid(id, valid, event) {
    var keyName = ("" + event.key).toLowerCase();

    //Ignore validation if tab, shift, ctrl
    if (keyName == "tab" || keyName == "shift") {
        return;
    }

    var inputField = $(id),
        name = inputField.attr("name"),
        key = name.capitalize();

    if (valid) {
        inputField.addClass('correct');
        $("#group" + key).addClass('has-success');
        $("#group" + key).removeClass('has-error');
        $("#group" + key + " .glyphicon").addClass('glyphicon-ok');
        $("#group" + key + " .glyphicon").removeClass('glyphicon-remove');
        $("#error" + key).hide();

    } else {
        var error = language.validation && language.validation[name] || {
            "name": key
        };

        inputField.removeClass('correct');
        $("#group" + key).addClass('has-error');
        $("#group" + key).removeClass('has-success');
        $("#group" + key + " .glyphicon").addClass('glyphicon-remove');
        $("#group" + key + " .glyphicon").removeClass('glyphicon-ok');
        $("#error" + key).text(inputField.val() ? error.validation : (error.empty ? error.empty : error.name + " " + language.std.empty));
        $("#error" + key).show();
    }
}